import { system } from "@minecraft/server";
import { SlugBuckets } from "../item/SlugBuckets.js";
import { MinecraftLiquid } from "../utils/MinecraftLiquid.js";
import { AbstractBucketableEntity } from "./AbstractBucketableEntity.js";
export class Slug extends AbstractBucketableEntity {
  static IDENTIFIER = 'sf_nba:slug';
  static BOUNCE_EVENT = 'sf_nba:should_bounce_player';
  constructor() {
    super(Slug.IDENTIFIER, SlugBuckets, 'minecraft:bucket', MinecraftLiquid.None, {
      empty: 'sf_nba.bucket.fill_slug',
      fill: 'sf_nba.bucket.empty_slug',
    });
    this.setupBounceHandler();
  }
  setupBounceHandler() {
    system.afterEvents.scriptEventReceive.subscribe((e) => {
      if (e.id !== Slug.BOUNCE_EVENT) return;
      const entity = e.sourceEntity;
      if (!entity || !entity.typeId) return;
      if (entity.typeId !== Slug.IDENTIFIER) return;
      const player = entity.dimension.getPlayers({ closest: 1, location: entity.location })[0];
      if (!player) return;
      const velocity = player.getVelocity();
      if (velocity.y < 0) {
        entity.playAnimation("animation.sf_nba.slug.bounce");
        player.applyKnockback(0, 0, 0, 0.8);
      } else {
        entity.triggerEvent('sf_nba:can_detect_bounce');
      }
    });
  }
}
new Slug();